<?php

namespace Drupal\dsr_sign_up_form\Validate;

use Drupal\Core\Form\FormStateInterface;

/**
 * Form API callback. Validate element value.
 */
class ValidateBelgianNationalNumber {

  /**
   * Validates given element.
   *
   * @param array $element
   *   The form element to process.
   * @param \Drupal\Core\Form\FormStateInterface $formState
   *   The form state.
   * @param array $form
   *   The complete form structure.
   */
  public static function validate(array &$element, FormStateInterface $formState, array &$form) {
    $form_key = $element['#parents'];
    $value = $formState->getValue($form_key);

    if (!$value) {
      return;
    }

    if (preg_match('/([0-9]{2})\.?([0-9]{2})\.?([0-9]{2})-?([0-9]{3})\.?([0-9]{2})/', $value, $matches)) {
      $number = $matches[1] . $matches[2] . $matches[3] . $matches[4];
      $info = $matches[5];
      $check = $number % 97;
      $checksum = 97 - $info;
      if ($check == $checksum) {
        return;
      }
      // Post 2000.
      $check = ($number + 2000000000) % 97;
      $checksum = 97 - $info;
      if ($check == $checksum) {
        return;
      }
    }
    $formState->setError(
      $element,
      t('The entered belgian national number is not valid!')
    );

  }

}
