<?php

namespace Drupal\dsr_sign_up_form\Validate;

use Drupal\Core\Form\FormStateInterface;

use Symfony\Component\Validator\Validation;
use Symfony\Component\Validator\Constraints\Iban;

/**
 * Form API callback. Validate element value.
 */
class ValidateIBANAccount {

  /**
   * Validates given element.
   *
   * @param array $element
   *   The form element to process.
   * @param \Drupal\Core\Form\FormStateInterface $formState
   *   The form state.
   * @param array $form
   *   The complete form structure.
   */
  public static function validate(array &$element, FormStateInterface $formState, array &$form) {
    $form_key = $element['#parents'];
    $value = $formState->getValue($form_key);

    if (!$value) {
      return;
    }

    $validator = Validation::createValidator();
    $constraint = new Iban();
    $violations = $validator->validate($value, $constraint);
    for ($i = 0; $i < $violations->count(); $i++) {
      $violation = $violations->get($i);
      $formState->setError(
        $element,
        $violation->getMessage()
      );
    }
  }

}
