<?php

namespace Drupal\dsr\Commands;

use Drush\Commands\DrushCommands;

/**
 * A Drush commandfile.
 *
 * In addition to this file, you need a drush.services.yml
 * in root of your module, and a composer.json file that provides the name
 * of the services file to use.
 *
 * See these files for an example of injecting Drupal services:
 *   - http://cgit.drupalcode.org/devel/tree/src/Commands/DevelCommands.php
 *   - http://cgit.drupalcode.org/devel/tree/drush.services.yml
 */
class DsrCommands extends DrushCommands {

  /**
   * Import a shareholder register.
   *
   * @param string $directory
   *   Directory containing 'shareholders.csv' and 'share_transactions.csv'.
   *
   * @command dsr:import-shareholder-register
   * @aliases import-shareholder-register
   */
  public function importDemo($directory) {
    \Drupal::service('dsr.drush')->importShareholderRegister($directory);
  }

  /**
   * Validate pending transactions.
   *
   * @command dsr:import-shareholder-register-validate
   * @aliases validate-shareholder-register
   */
  public function importValidateTransactions() {
    \Drupal::service('dsr.drush')->importShareholderRegisterValidate();
  }

}
