<?php

namespace Drupal\dsr\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\JsonResponse;

use Drupal\shareholder_register\Entity\ShareType;
use Drupal\shareholder_register\Entity\ShareTransaction;

/**
 * Controller for public shareholder register stats json.
 *
 * Sample usage:
 *
 * $.getJSON('https://dar.startx.be/shareholder-register-stats', function( data ) {
 *   $('#share-counter').html(
 *     "Shares:" + data.data.shares
 *   );
 * });
 *
 * Don't forget to set CORS settings in services.yml
 */
class PublicShareholderRegisterStatsController extends ControllerBase {

  /**
   * {@inheritdoc}
   */
  public function data() {
    $json_array = [
      'data' => [],
    ];

    $json_array['data']['shareholders'] = (int) \Drupal::EntityQuery('shareholder')
      ->accessCheck(FALSE)
      ->condition('state', 'valid')
      ->count()->execute();

    $sharetypes = ShareType::loadMultiple();
    $json_array['data']['shares'] = array_sum(array_map(function ($s) {
      return $s->get('share_count')->value;

    }, $sharetypes));

    $pendingtransactions = \Drupal::EntityQuery('share_transaction')
      ->accessCheck(FALSE)
      ->condition('state', 'draft')
      ->execute();

    $json_array['data']['pending-shares'] = array_sum(
      array_map(function ($t) {
        return $t->get('quantity')->value;

      }, ShareTransaction::loadMultiple($pendingtransactions)));

    return new JsonResponse($json_array);
  }

}
