<?php

namespace Drupal\dsr\Plugin\Block;

use Drupal\Core\Block\BlockBase;
use Drupal\Core\Cache\Cache;

/**
 * Provides a 'Dsr Help' Block.
 *
 * @Block(
 *   id = "dsr_help_block",
 *   admin_label = @Translation("DSR Help Block"),
 *   category = @Translation("DSR"),
 * )
 */
class DsrHelpBlock extends BlockBase {

  /**
   * {@inheritdoc}
   */
  public function build() {
    $ah = \Drupal::service('plugin.manager.advanced_help');
    $route = \Drupal::routeMatch()->getRouteName();
    $all_topics = $ah->getTopics();
    $topics = [];
    if (isset($all_topics['dsr'])) {
      $topics = $all_topics['dsr'];
    }
    foreach ($topics as $key => $topic) {
      if (isset($topic['ini']['routes']) && in_array($route, $topic['ini']['routes'])) {
        return [
          [
            '#theme' => 'advanced_help_topic',
            '#module' => 'dsr',
            '#topic' => $key,
            '#type' => 'title',
            '#attached' => [
              'library' => [
                'dsr/global',
              ],
            ],
          ],
        ];
      }
    }
    return [];
  }

  /**
   *
   */
  public function getCacheContexts() {
    return Cache::mergeContexts(parent::getCacheContexts(), ['route']);
  }

}
