<?php

namespace Drupal\dsr\Plugin\Block;

use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;

use Drupal\dsr\DsrDrushServiceInterface;

use Drupal\Core\Block\BlockBase;
use Drupal\Core\Cache\Cache;

/**
 * Provides a 'Dsr Version' Block.
 *
 * @Block(
 *   id = "dsr_version_block",
 *   admin_label = @Translation("DSR Version Block"),
 *   category = @Translation("DSR"),
 * )
 */
class DsrVersionBlock extends BlockBase implements ContainerFactoryPluginInterface {

  /**
   * DsrService definition.
   *
   * @var \Drupal\dsr\DsrDrushServiceInterface
   */
  protected $dsrService;

  /**
   * {@inheritdoc}
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, DsrDrushServiceInterface $dsrService) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->dsrService = $dsrService;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('dsr.drush')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function build() {
    $version = implode(
      ', ',
      array_map(
        function ($v) {
          return $this->t(
            '@name Version @version',
            [
              '@name' => $v['name'],
              '@version' => $v['version']
            ]
          );
        },
        $this->dsrService->getVersion()
      )
    );

    return [
      '#prefix' => '<div class="dsr-version"><span>',
      '#suffix' => '</span></div>',
      '#markup' => $version,
    ];
  }

}
