<?php

/**
 * @file
 * Contains dividend_distribution.page.inc.
 *
 * Page callback for Dividend distribution entities.
 */

use Drupal\Core\Render\Element;

/**
 * Prepares variables for Dividend distribution templates.
 *
 * Default template: dividend_distribution.html.twig.
 *
 * @param array $variables
 *   An associative array containing:
 *   - elements: An associative array containing the user information and any
 *   - attributes: HTML attributes for the containing element.
 */
function template_preprocess_dividend_distribution(array &$variables) {
  // Fetch DividendDistribution Entity Object.
  $dividend_distribution = $variables['elements']['#dividend_distribution'];

  // Helpful $content variable for templates.
  foreach (Element::children($variables['elements']) as $key) {
    $variables['content'][$key] = $variables['elements'][$key];
  }
}
