<?php

/**
 * @file
 * Contains shareholder_dividend.page.inc.
 *
 * Page callback for Shareholder dividend entities.
 */

use Drupal\Core\Render\Element;

/**
 * Prepares variables for Shareholder dividend templates.
 *
 * Default template: shareholder_dividend.html.twig.
 *
 * @param array $variables
 *   An associative array containing:
 *   - elements: An associative array containing the user information and any
 *   - attributes: HTML attributes for the containing element.
 */
function template_preprocess_shareholder_dividend(array &$variables) {
  // Fetch ShareholderDividend Entity Object.
  $shareholder_dividend = $variables['elements']['#shareholder_dividend'];

  // Helpful $content variable for templates.
  foreach (Element::children($variables['elements']) as $key) {
    $variables['content'][$key] = $variables['elements'][$key];
  }
}
