<?php

use Drupal\shareholder_register_dividend\Entity\ShareholderDividend;
use Drupal\shareholder_register_dividend\Entity\DividendDistribution;

/**
 * Implements hook_drush_command().
 */
function shareholder_register_dividend_drush_command() {

  $commands['import-dividend'] = [
    'description' => 'This command will import a file with dividends.',
    'aliases' => ['sr-idiv'],
    'arguments' =>
    [
      'dist' => 'Distribution for which to import dividends.',
      'file' => 'location of the csv file (col A = shareholder number, col D = net, col E = gross)',
    ],
    'options' => [],
    'examples' => [],
  ];

  $commands['register-dividend'] = [
    'description' => 'This command will register a dividend.',
    'aliases' => ['sr-rdiv'],
    'arguments' =>
    [
      'dividend_date' => 'The date of the dividend distribution',
      'dividend' => 'The dividend per share',
      'begin_of_period' => 'Start date of dividend allocation period',
      'end_of_period' => 'End date of dividend allocation period',
      'allocation_method' => 'Plugin id of the allocation method',
      'tax_method' => 'Plugin id of the tax method',
      'distribution' => 'Name of the distribution',
    ],
    'options' => [],
    'examples' => [],
  ];

  return $commands;
}

/**
 * Drush command logic.
 */
function drush_shareholder_register_dividend_register_dividend(
  $dividend_date,
  $dividend,
  $begin_of_period,
  $end_of_period,
  $allocation_method,
  $tax_method,
  $distribution) {
  $dividend_config = [
    'dividend_date' => $dividend_date,
    'dividend' => $dividend,
    'start_date' => $begin_of_period,
    'end_date' => $end_of_period,
    'allocation' => $allocation_method,
    'tax' => $tax_method,
    'total_hash' => "\Drupal\shareholder_register_dividend\DividendService::dividendTotalHash",
  ];

  $s = \Drupal::service('shareholder_register_dividend.default');
  $batch = $s->getDividendAllocationBatch($dividend_config);
  $batch['operations'][] = [
    '\Drupal\shareholder_register_dividend\Form\DividendForm::registerDividend',
    [
      $distribution,
    ],
  ];

  batch_set($batch);
  $batch =& batch_get();
  $batch['progressive'] = FALSE;

  // Process the batch.
  drush_backend_batch_process();
}

/**
 * Drush command logic.
 */
function drush_shareholder_register_dividend_import_dividend($file, $dist) {

  if (($handle = fopen($file, "r")) !== FALSE) {
    $distribution = DividendDistribution::create([
      'name' => $dist,
    ]);
    $distribution->save();

    $n = 1;
    while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
      if (!is_numeric($data[3])) {
        drush_print("Ignoring row {$n}: col D is not numeric");
        continue;
      }
      if (!is_numeric($data[4])) {
        drush_print("Ignoring row {$n}: col E is not numeric");
        continue;
      }

      $shareholders = \Drupal::entityTypeManager()
        ->getStorage('shareholder')
        ->loadByProperties([
          'number' => trim($data[0]),
          'state' => 'valid',
        ]);

      if (!count($shareholders)) {
        drush_print("Ignoring row {$n}: shareholder with number '{$data[0]}' not found!");
        continue;
      }

      $d = ShareholderDividend::create([
        'distribution_id' => $distribution->id(),
        'shareholder_id' => reset($shareholders)->id(),
        'gross' => $data[4],
        'net' => $data[3],
      ]);
      $d->save();

      $n++;
    }
    fclose($handle);
  }
  else {
    drush_print("Could not open file {$file}!");
  }
}
