<?php

namespace Drupal\shareholder_register_dividend;

use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Access\AccessResult;

/**
 * Access controller for the Dividend distribution entity.
 *
 * @see \Drupal\shareholder_register_dividend\Entity\DividendDistribution.
 */
class DividendDistributionAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    /** @var \Drupal\shareholder_register_dividend\Entity\DividendDistributionInterface $entity */
    switch ($operation) {
      case 'view':
        return AccessResult::allowedIfHasPermission($account, 'view published dividend distribution entities');

      case 'update':
        return AccessResult::allowedIfHasPermission($account, 'edit dividend distribution entities');

      case 'delete':
        if ($entity->getState() == 'valid') {
          return AccessResult::forbidden();
        }
        return AccessResult::allowedIfHasPermission($account, 'delete dividend distribution entities');
    }

    // Unknown operation, no opinion.
    return AccessResult::neutral();
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    return AccessResult::allowedIfHasPermission($account, 'add dividend distribution entities');
  }

}
