<?php

namespace Drupal\shareholder_register_dividend;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;
use Drupal\Core\Link;

/**
 * Defines a class to build a listing of Dividend distribution entities.
 *
 * @ingroup shareholder_register_dividend
 */
class DividendDistributionListBuilder extends EntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['name'] = $this->t('Name');
    $header['date'] = $this->t('Date');
    $header['total_gross'] = $this->t('Total Gross');
    $header['total_net'] = $this->t('Total Net');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /* @var $entity \Drupal\shareholder_register_dividend\Entity\DividendDistribution */
    $row['name'] = Link::createFromRoute(
      $entity->label(),
      'entity.dividend_distribution.canonical',
      ['dividend_distribution' => $entity->id()]
    );
    $row['date'] = $entity->getDate();
    $row['total_gross'] = $entity->get('total_gross')->value;
    $row['total_net'] = $entity->get('total_net')->value;
    return $row + parent::buildRow($entity);
  }

}
