<?php

namespace Drupal\shareholder_register_dividend\Entity;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface for defining Dividend distribution entities.
 *
 * @ingroup shareholder_register_dividend
 */
interface DividendDistributionInterface extends ContentEntityInterface, EntityChangedInterface, EntityOwnerInterface {

  // Add get/set methods for your configuration properties here.

  /**
   * Gets the Dividend distribution name.
   *
   * @return string
   *   Name of the Dividend distribution.
   */
  public function getName();

  /**
   * Sets the Dividend distribution name.
   *
   * @param string $name
   *   The Dividend distribution name.
   *
   * @return \Drupal\shareholder_register_dividend\Entity\DividendDistributionInterface
   *   The called Dividend distribution entity.
   */
  public function setName($name);

  /**
   * Gets the Dividend distribution creation timestamp.
   *
   * @return int
   *   Creation timestamp of the Dividend distribution.
   */
  public function getCreatedTime();

  /**
   * Sets the Dividend distribution creation timestamp.
   *
   * @param int $timestamp
   *   The Dividend distribution creation timestamp.
   *
   * @return \Drupal\shareholder_register_dividend\Entity\DividendDistributionInterface
   *   The called Dividend distribution entity.
   */
  public function setCreatedTime($timestamp);

}
