<?php

namespace Drupal\shareholder_register_dividend\Entity;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface for defining Shareholder dividend entities.
 *
 * @ingroup shareholder_register_dividend
 */
interface ShareholderDividendInterface extends ContentEntityInterface, EntityChangedInterface, EntityOwnerInterface {

  /**
   * Gets the Shareholder dividend name.
   *
   * @return string
   *   Name of the Shareholder dividend.
   */
  public function getName();

  /**
   * Sets the Shareholder dividend name.
   *
   * @param string $name
   *   The Shareholder dividend name.
   *
   * @return \Drupal\shareholder_register_dividend\Entity\ShareholderDividendInterface
   *   The called Shareholder dividend entity.
   */
  public function setName($name);

  /**
   * Gets the Shareholder dividend creation timestamp.
   *
   * @return int
   *   Creation timestamp of the Shareholder dividend.
   */
  public function getCreatedTime();

  /**
   * Sets the Shareholder dividend creation timestamp.
   *
   * @param int $timestamp
   *   The Shareholder dividend creation timestamp.
   *
   * @return \Drupal\shareholder_register_dividend\Entity\ShareholderDividendInterface
   *   The called Shareholder dividend entity.
   */
  public function setCreatedTime($timestamp);

}
