<?php
namespace Drupal\shareholder_register_dividend\Event;

use Drupal\shareholder_register_dividend\Entity\ShareholderDividendInterface;
use Symfony\Component\EventDispatcher\Event;

/**
 * Shareholder Dividend Event.
 *
 */
class ShareholderRegisterDividendEvent extends Event {

  const VALIDATE_EVENT_NAME = 'shareholder_register_dividend_validate_event';

  /**
   * The shareholder.
   *
   * @var \Drupal\shareholder_register_dividend\Entity\ShareholderDivdidendInterface
   */
  protected $shareholderDividend;

  /**
   * Constructs the object.
   *
   * @param \Drupal\shareholder_register_dividend\Entity\ShareholderDividendInterface $shareholderDividend
   *   The Shareholder dividend.
   */
  public function __construct(ShareholderDividendInterface $shareholderDividend) {
    $this->shareholderDividend = $shareholderDividend;
  }

  /**
   * {@inheritdoc}
   */
  public function getShareholderDividend() {
    return $this->shareholderDividend;
  }

}
