<?php

namespace Drupal\shareholder_register_dividend\Form;

use Drupal\Core\Entity\ContentEntityDeleteForm;
use Drupal\Core\Form\FormStateInterface;

use Drupal\shareholder_register_dividend\Exception\ShareholderRegisterDividendException;

/**
 * Provides a form for deleting Dividend distribution entities.
 *
 * @ingroup shareholder_register_dividend
 */
class DividendDistributionDeleteForm extends ContentEntityDeleteForm {

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    try {
      parent::submitForm($form, $form_state);
    }
    catch (ShareholderRegisterDividendException $e) {
      $this->messenger()->addError(
        $this->t('Could not delete dividend distribution:') . ' ' .
        $this->t($e->getMessage(), $e->getMsgPlaceholders())
      );
    }
  }
}
