<?php

namespace Drupal\shareholder_register_dividend\Form;

use Drupal\Core\Entity\ContentEntityForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form controller for Dividend distribution edit forms.
 *
 * @ingroup shareholder_register_dividend
 */
class DividendDistributionForm extends ContentEntityForm {

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    /* @var $entity \Drupal\shareholder_register_dividend\Entity\DividendDistribution */
    $form = parent::buildForm($form, $form_state);

    $entity = $this->entity;

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {
    $entity = $this->entity;

    $status = parent::save($form, $form_state);

    switch ($status) {
      case SAVED_NEW:
        drupal_set_message($this->t('Created the %label Dividend distribution.', [
          '%label' => $entity->label(),
        ]));
        break;

      default:
        drupal_set_message($this->t('Saved the %label Dividend distribution.', [
          '%label' => $entity->label(),
        ]));
    }
    $form_state->setRedirect('entity.dividend_distribution.canonical', ['dividend_distribution' => $entity->id()]);
  }

}
