<?php
namespace Drupal\shareholder_register_dividend\Plugin\Action;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;

use Drupal\shareholder_register_dividend\Entity\DividendDistribution;

use Drupal\mail_template\Plugin\Action\DownloadDocumentAction;

/**
 * Download Dividend Document.
 *
 * @Action(
 *   id = "download_dividend_document_action",
 *   label = @Translation("Download Dividend Document"),
 *   type = "shareholder"
 * )
 */
class DownloadDividendDocumentAction extends DownloadDocumentAction {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'distribution' => '',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $options = [];
    foreach (DividendDistribution::loadMultiple() as $d) {
      $options[$d->id()] = $d->getName();
    }

    $form['distribution'] = [
      '#type' => 'select',
      '#title' => $this->t("Distribution"),
      '#options' => $options,
    ];
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    parent::submitConfigurationForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function execute($entity = NULL) {
    if ($entity) {
      $this->mailTemplateService = \Drupal::service('mail_template.default');
      $this->dividendService = \Drupal::service('shareholder_register_dividend.default');

      $context = $this->dividendService->getDividendContext($entity, $this->configuration['distribution']);
      $context['entity'] = $entity;

      $file = FALSE;

      if ($context['gross'] > 0 || $context['tax'] > 0) {
        $file = $this->mailTemplateService->pdfForRenderArrays(
          [$this->mailTemplateService->renderArrayForTemplate('dividend_document', $context)],
          $this->mailTemplateService->pdfOptionsForTemplate('dividend_document', $context));
      }

      if (!isset($this->context['sandbox']['results'])) {
        $this->context['sandbox']['results'] = [];
      }

      $this->context['sandbox']['results'][] = $file;
    }
  }

}
