<?php
namespace Drupal\shareholder_register_dividend\Plugin\Action;

use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;

use Drupal\views_bulk_operations\Action\ViewsBulkOperationsActionBase;

use Drupal\shareholder_register_dividend\Entity\DividendDistribution;

/**
 * Mail Dividend Document.
 *
 * @Action(
 *   id = "mail_dividend_document_action",
 *   label = @Translation("Mail Dividend Document"),
 *   type = "shareholder"
 * )
 */
class MailDividendDocumentAction extends ViewsBulkOperationsActionBase {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'distribution' => '',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $options = [];
    foreach (DividendDistribution::loadMultiple() as $d) {
      $options[$d->id()] = $d->getName();
    }

    $form['distribution'] = [
      '#type' => 'select',
      '#title' => $this->t("Distribution"),
      '#options' => $options,
    ];
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    parent::submitConfigurationForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function execute($entity = NULL) {
    if ($entity) {
      $s = \Drupal::service('shareholder_register_dividend.default');
      $s->sendDividendMail($entity, $this->configuration['distribution']);
    }
  }

  /**
   * {@inheritdoc}
   */
  public function access($object, AccountInterface $account = NULL, $return_as_object = FALSE) {
    if ($object->getState() != 'valid') {
      $result = AccessResult::forbidden();
    }
    else {
      $result = $object->access('view', $account, TRUE);
    }
    return $return_as_object ? $result : $result->isAllowed();
  }

}
