<?php
namespace Drupal\shareholder_register_dividend\Plugin\DividendAllocation;

use Drupal\shareholder_register_dividend\Plugin\DividendAllocationDefinitionBase;

/**
 * Prorata.
 *
 * @DividendAllocationDefinition(
 *   id = "at_end_date",
 *   label = @Translation("At End Date"),
 *  )
 */
class AtEndDate extends DividendAllocationDefinitionBase {

  /**
   * {@inheritdoc}
   */
  public function getDividendBase($dividend_config) {
    return 1;
  }

  /**
   * {@inheritdoc}
   */
  public function computeDividend($shareholder, $dividend_config) {
    $result = [];

    $start_date = $dividend_config['start_date'];
    $end_date = $dividend_config['end_date'];

    $shares = $shareholder->getSharesAtDate($end_date);
    foreach ($shares as $share) {
      $dividend = new \stdClass();
      $dividend->share_id = $share->id();
      $dividend->shareholder_id = $shareholder->id();
      $dividend->start_date = $start_date;
      $dividend->end_date = $end_date;
      $dividend->tax = 0;
      $dividend->fraction = 1;

      $result[] = $dividend;
    }
    return $result;
  }

}
