<?php
namespace Drupal\shareholder_register_dividend\Plugin\DividendAllocation;

/**
 * Prorata.
 *
 * @DividendAllocationDefinition(
 *   id = "prorata_month_excl",
 *   label = @Translation("Prorata Monthly (excl 1st)"),
 *  )
 */
class ProRataMonthExcl extends ProRataMonth {

  /**
   * The date at which to determine initial state.
   */
  protected static function getInitialDate($date) {
    // Get initial state from d-1.
    return date('Y-m-d', strtotime("{$date} previous day"));
  }

  /**
   * Return the next first day of month.
   *
   * Return the first day of next month.
   */
  protected static function startOfPeriod($date) {
    $d = new \DateTime($date);
    return date('Y-m-d', strtotime("{$date} first day of next month"));
  }

}
