<?php

namespace Drupal\shareholder_register_dividend\Plugin;

use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;

/**
 * {@inheritdoc}
 */
class DividendAllocationDefinitionManager extends DefaultPluginManager {

  /**
   * {@inheritdoc}
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
      'Plugin/DividendAllocation',
      $namespaces,
      $module_handler,
      'Drupal\shareholder_register_dividend\Plugin\DividendAllocationDefinitionInterface',
      'Drupal\shareholder_register_dividend\Annotation\DividendAllocationDefinition');

    $this->alterInfo('dividend_allocation_definition_info');
    $this->setCacheBackend($cache_backend, 'dividend_allocation_definitions');
  }
}
