<?php
namespace Drupal\shareholder_register_dividend\Plugin\DividendTax;

use Drupal\shareholder_register_dividend\Plugin\DividendTaxDefinitionBase;

/**
 * Belgian 2018 Dividend RV tax.
 *
 * @DividendTaxDefinition(
 *   id = "BE2018",
 *   label = @Translation("BE 2018 (30%)"),
 *  )
 */
class BE2018 extends DividendTaxDefinitionBase {

  /**
   * {@inheritdoc}
   */
  public function computeDividendTaxRate($shareholder, $dividends, $dividend_config) {
    foreach ($dividends as $dividend) {
      $dividend->tax = 30;
      $dividend->taxcode = '30';
    }
  }

}
