<?php

namespace Drupal\shareholder_register_dividend\Plugin;

use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;

/**
 * {@inheritdoc}
 */
class DividendTaxDefinitionManager extends DefaultPluginManager {

  /**
   * {@inheritdoc}
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
      'Plugin/DividendTax',
      $namespaces,
      $module_handler,
      'Drupal\shareholder_register_dividend\Plugin\DividendTaxDefinitionInterface',
      'Drupal\shareholder_register_dividend\Annotation\DividendTaxDefinition');

    $this->alterInfo('dividend_tax_definition_info');
    $this->setCacheBackend($cache_backend, 'dividend_tax_definitions');
  }
}
