<?php

namespace Drupal\shareholder_register_dividend\Plugin\Field\FieldType;

use Drupal\Core\Field\FieldItemList;
use Drupal\Core\TypedData\ComputedItemListTrait;

use Drupal\shareholder_register_dividend\Entity\DividendDistributionInterface;

/**
 * {@inheritdoc}
 */
class DistributionTotalItemList extends FieldItemList {
  use ComputedItemListTrait;

  /**
   * {@inheritdoc}
   */
  protected function computeValue() {
    $computed_values = [0];

    $entity = $this->getEntity();
    if (!$entity->isNew()) {
      $value = 0;
      if ($entity instanceof DividendDistributionInterface) {
        $connection = \Drupal::database();

        $sum_field = $this->getSetting('sum_field');
        if (!in_array($sum_field, ['gross', 'net'])) {
          $sum_field = 'gross';
        }

        $r = $connection->query(
          "SELECT SUM({$sum_field}) AS value FROM {shareholder_dividend} WHERE distribution_id = :distribution_id",
          [
            ':distribution_id' => $entity->id(),
          ]);
        $computed_values[0] = $r->fetchAssoc()['value'];
      }
    }

    foreach ($computed_values as $delta => $value) {
      $this->list[$delta] = $this->createItem($delta, $value);
    }
  }

}
