<?php

namespace Drupal\shareholder_register_dividend\Plugin\Field\FieldType;

use Drupal\Core\Field\EntityReferenceFieldItemList;
use Drupal\Core\TypedData\ComputedItemListTrait;

use Drupal\shareholder_register_dividend\Entity\ShareholderDividend;

/**
 * {@inheritdoc}
 */
class ShareholderDividendsItemList extends EntityReferenceFieldItemList {
  use ComputedItemListTrait;

  /**
   * Compute the values.
   */
  protected function computeValue() {
    $entity = $this->getEntity();

    $values = [];
    if ($entity->getEntityTypeId() == 'shareholder') {
      $values = ShareholderDividend::loadMultiple(
        \Drupal::entityQuery('shareholder_dividend')
          ->condition('shareholder_id', $entity->id())
          ->execute()
      );
    }
    elseif ($entity->getEntityTypeId() == 'dividend_distribution') {
      $values = ShareholderDividend::loadMultiple(
        \Drupal::entityQuery('shareholder_dividend')
          ->condition('distribution_id', $entity->id())
          ->execute()
      );
    }

    if ($values) {
      $n = 0;
      foreach ($values as $delta => $value) {
        $this->list[$n] = $this->createItem($delta, $value);
        $n++;
      }
    }
  }

  /**
   * {@inheritdoc}
   */
  public function referencedEntities() {
    $this->ensureComputedValue();
    return parent::referencedEntities();
  }

  /**
   * {@inheritdoc}
   */
  public function getReferencedEntities() {
    // Duplicate method, with prefix get for use in twig templates.
    $this->valueComputed = FALSE;
    return $this->referencedEntities();
  }

}
