<?php

namespace Drupal\shareholder_register_dividend\Plugin\WorkflowType;

use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\workflows\Plugin\WorkflowTypeBase;

/**
 * Dividend Distribution workflow type.
 *
 * @WorkflowType(
 *   id = "workflow_dividend_distribution",
 *   label = @Translation("Dividend Distribution Workflow"),
 *   required_states = {
 *     "draft",
 *     "valid",
 *   }
 * )
 */
class DividendDistributionWorkflowType extends WorkflowTypeBase {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'states' => [
        'draft' => [
          'label' => 'Draft',
          'weight' => 0,
        ],
        'valid' => [
          'label' => 'Valid',
          'weight' => 1,
        ],
      ],
      'transitions' => [
        'validate' => [
          'label' => 'Validate',
          'to' => 'valid',
          'weight' => 0,
          'from' => [
            'draft',
          ],
        ],
      ],
    ];
  }

}
