<?php

namespace Drupal\shareholder_register_dividend;

use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Access\AccessResult;

/**
 * Access controller for the Shareholder dividend entity.
 *
 * @see \Drupal\shareholder_register_dividend\Entity\ShareholderDividend.
 */
class ShareholderDividendAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    /** @var \Drupal\shareholder_register_dividend\Entity\ShareholderDividendInterface $entity */
    switch ($operation) {
      case 'view':
        return AccessResult::allowedIfHasPermission($account, 'view published shareholder dividend entities');

      case 'update':
        return AccessResult::allowedIfHasPermission($account, 'edit shareholder dividend entities');

      case 'delete':
        return AccessResult::allowedIfHasPermission($account, 'delete shareholder dividend entities');
    }

    // Unknown operation, no opinion.
    return AccessResult::neutral();
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    return AccessResult::allowedIfHasPermission($account, 'add shareholder dividend entities');
  }

}
