<?php

namespace Drupal\shareholder_register_dividend;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;

/**
 * Defines a class to build a listing of Shareholder dividend entities.
 *
 * @ingroup shareholder_register_dividend
 */
class ShareholderDividendListBuilder extends EntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['distribution'] = $this->t('Distribution');
    $header['date'] = $this->t('Date');
    $header['shareholder'] = $this->t('Shareholder');
    $header['gross'] = $this->t('Gross');
    $header['net'] = $this->t('Net');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /* @var $entity \Drupal\shareholder_register_dividend\Entity\ShareholderDividend */
    $row['distribution'] = $entity->getDistribution()->getName();
    $row['date'] = $entity->getDistribution()->getDate();
    $row['shareholder'] = $entity->getShareholder()->label();
    $row['gross'] = $entity->getGross();
    $row['net'] = $entity->getNet();
    return $row + parent::buildRow($entity);
  }

}
