<?php

namespace Drupal\Tests\shareholder_register_dividend\Kernel;

use Drupal\shareholder_register\Entity\Shareholder;
use Drupal\shareholder_register_dividend\DividendService;
use Drupal\shareholder_register_dividend\Entity\ShareholderDividend;
use Drupal\shareholder_register_dividend\Form\DividendForm;

use Drupal\KernelTests\KernelTestBase;
use Drupal\Tests\shareholder_register\Traits\LoadRegisterTrait;

/**
 * Tests Dividend.
 *
 * @group shareholder_register
 */
class RegisterDividendTest extends KernelTestBase {

  use LoadRegisterTrait;

  /**
   * Modules to enable.
   *
   * @var array
   */
  public static $modules = [
    'system',
    'user',
    'file',
    'text',
    'datetime',
    'simple_workflows',
    'shareholder_register',
    'shareholder_register_dividend',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp() {
    parent::setUp();
    $this->traitSetUp();
    $this->installEntitySchema('dividend_distribution');
    $this->installEntitySchema('shareholder_dividend');
  }

  /**
   * Test Prorata allocation.
   */
  public function testProrataAllocation() {
    $register = $this->loadBasicRegister(
      [
        'shareholders' => [
          [
            'number' => 1,
          ],
        ],
        'transactions' => [
          [
            'quantity' => 5,
            'shareholder_number' => 1,
            'payment_date' => '2017-01-02',
            'validation_date' => '2017-02-02',
          ],
        ],
      ]);

    $dividend_config = [
      'dividend_date' => '2018-03-01',
      'dividend' => 15,
      'start_date' => '2017-01-01',
      'end_date' => '2018-01-01',
      'allocation' => 'prorata',
      'use_payment_date' => 0,
      'tax' => 'BE2018',
      'total_hash' => "\Drupal\shareholder_register_dividend\DividendService::dividendTotalHash",
    ];

    $context = [];
    DividendService::initDividendBatch($dividend_config, $context);
    DividendService::dividendBatch($dividend_config, $context);

    DividendForm::registerDividend("test", $context);

    // Validate registered totals.
    $d = ShareholderDividend::load(1);
    $this->assertEqual($d->gross->value, "68.42");
    $this->assertEqual($d->net->value, "47.89", "assert 68.42 - (68.42 * 0.3) rounded = 47.89");
  }

}
