<?php

namespace Drupal\Tests\shareholder_register_dividend\Kernel;

use Drupal\shareholder_register\Entity\Shareholder;
use Drupal\shareholder_register_dividend\DividendService;

use Drupal\KernelTests\KernelTestBase;
use Drupal\Tests\shareholder_register\Traits\LoadRegisterTrait;

/**
 * Tests Dividend VVPR.
 *
 * @group shareholder_register
 */
class VVPRTest extends KernelTestBase {

  use LoadRegisterTrait;

  /**
   * Modules to enable.
   *
   * @var array
   */
  public static $modules = [
    'system',
    'user',
    'file',
    'text',
    'datetime',
    'simple_workflows',
    'shareholder_register',
    'shareholder_register_dividend',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp() {
    parent::setUp();
    $this->traitSetUp();
    $this->installEntitySchema('dividend_distribution');
    $this->installEntitySchema('shareholder_dividend');
  }

  /**
   * Test consistent rounding between excel and registration, test use payment date for VVPR taxcode.
   */
  public function testVVPRDateAndGrouping() {
    $register = $this->loadBasicRegister(
      [
        'shareholders' => [
          [
            'number' => 1,
          ],
        ],
        'transactions' => [
          [
            'quantity' => 1,
            'shareholder_number' => 1,
            'validation_date' => '2020-01-01',
            'payment_date' => '2012-02-01',
          ],
          [
            'quantity' => 1,
            'shareholder_number' => 1,
            'validation_date' => '2020-01-01',
            'payment_date' => '2016-02-01',
          ],
        ],
      ]);

    $dividend_config = [
      'dividend_date' => '2018-03-01',
      'dividend' => 1.005,
      'start_date' => '2017-01-01',
      'end_date' => '2018-01-01',
      'allocation' => 'prorata_month',
      'use_payment_date' => 1,
      'tax' => 'BE2018VVPR',
      'total_hash' => "\Drupal\shareholder_register_dividend\DividendService::dividendTotalHash",
    ];

    $context = [];
    DividendService::initDividendBatch($dividend_config, $context);
    DividendService::dividendBatch($dividend_config, $context);

    $totals = $context['results']['totals'];

    $this->assertEqual(count($totals), 1);
    $this->assertEqual(reset($totals)['fraction'], 24);
    $this->assertEqual(count(reset($totals)['grouped']), 1);
    $this->assertEqual(count(reset(reset($totals)['grouped'])['taxcode']), 2);
  }

}
