<?php

/**
 * Implements hook_drush_command().
 */
function shareholder_register_taxshelter_drush_command() {

  $commands['generate-taxshelter'] = [
    'description' => 'This command will generate the taxshelter documents for the given year.',
    'aliases' => ['gen-tax'],
    'arguments' =>
    [
      'year' => 'Year for which to generate documents.',
    ],
    'options' => [],
    'examples' => [],
  ];
  $commands['generate-single-taxshelter'] = [
    'description' => 'This command will generate the taxshelter documents for the given year.',
    'aliases' => ['gen-tax-1'],
    'arguments' =>
    [
      'shareholder' => 'Database ID of the shareholder.',
      'year' => 'Year for which to generate documents.',
    ],
    'options' => [],
    'examples' => [],
  ];
  $commands['download-taxshelter'] = [
    'description' => 'This command will download the taxshelter documents for the given year.',
    'aliases' => ['down-tax'],
    'arguments' =>
    [
      'year' => 'Year for which to download documents.',
      'folder' => 'The folder to store the documents.',
    ],
    'options' => [],
    'examples' => [],
  ];

  $commands['taxshelter-claim-for-transaction'] = [
    'description' => 'This command will create claim for a single share transaction.',
    'aliases' => ['claim-for-transaction'],
    'arguments' =>
    [
      'transaction' => 'Transaction ID.',
      'force' => 'Bypass checks',
      'share_ids' => 'Share ID.',
    ],
    'options' => [
      'force' => 'Force claim creation (bypass checks)',
    ],
    'examples' => [],
  ];

  $commands['generate-taxshelter-document'] = [
    'description' => 'This command will (re)generate the document for the given claim.',
    'aliases' => [],
    'arguments' =>
    [
      'claim_id' => 'Taxshelter Claim ID.',
    ],
    'options' => [],
    'examples' => [],
  ];

  return $commands;
}


/**
 * Drush command logic.
 */
function drush_shareholder_register_taxshelter_generate_taxshelter($year, $max_date = FALSE) {
  \Drupal::service('shareholder_register_taxshelter.drush')
    ->generateTaxshelter($year, $max_date);
}

/**
 * Drush command logic.
 */
function drush_shareholder_register_taxshelter_generate_single_taxshelter($shareholder, $year) {
  \Drupal::service('shareholder_register_taxshelter.drush')
    ->generateSingleTaxshelter($shareholder, $year);
}

/**
 * Drush command logic.
 */
function drush_shareholder_register_taxshelter_download_taxshelter($year, $folder) {
  \Drupal::service('shareholder_register_taxshelter.drush')
    ->downloadTaxshelter($year, $folder);
}

/**
 * Drush command logic.
 */
function drush_shareholder_register_taxshelter_taxshelter_claim_for_transaction($transaction_id, $force = FALSE, $share_ids = FALSE) {
  \Drupal::service('shareholder_register_taxshelter.drush')
    ->claimForTransaction($transaction_id, $force, $share_ids);
}

/**
 * Drush command logic.
 */
function drush_shareholder_register_taxshelter_generate_taxshelter_document($claim_id) {
  \Drupal::service('shareholder_register_taxshelter.drush')
    ->generateCertificate($claim_id);
}
