<?php

namespace Drupal\shareholder_register_taxshelter\Commands;

use Drupal\shareholder_register\Entity\Shareholder;

use Drush\Commands\DrushCommands;

/**
 * A Drush commandfile.
 *
 * In addition to this file, you need a drush.services.yml
 * in root of your module, and a composer.json file that provides the name
 * of the services file to use.
 *
 * See these files for an example of injecting Drupal services:
 *   - http://cgit.drupalcode.org/devel/tree/src/Commands/DevelCommands.php
 *   - http://cgit.drupalcode.org/devel/tree/drush.services.yml
 */
class ShareholderRegisterTaxshelterCommands extends DrushCommands {

  /**
   * This command will generate the taxshelter documents for the given year.
   *
   * @param int $year
   *   Year for which to generate documents.
   *
   * @command generate:taxshelter
   * @aliases gen-tax,generate-taxshelter
   */
  public function taxshelter($year, $max_date = FALSE) {
    \Drupal::service('shareholder_register_taxshelter.drush')
      ->generateTaxshelter($year, $max_date);
  }

  /**
   * This command will generate the taxshelter documents for the given year.
   *
   * @param int $shareholder_id
   *   Database ID of the shareholder.
   * @param int $year
   *   Year for which to generate documents.
   *
   * @command generate:single-taxshelter
   * @aliases gen-tax-1,generate-single-taxshelter
   */
  public function singleTaxshelter($shareholder_id, $year) {
    $shareholder = Shareholder::load($shareholder_id);
    \Drupal::service('shareholder_register_taxshelter.drush')
      ->generateSingleTaxshelter($shareholder, $year);
  }

  /**
   * This command will download the taxshelter documents for the given year.
   *
   * @param int $year
   *   Year for which to download documents.
   * @param string $folder
   *   The folder to store the documents.
   *
   * @command download:taxshelter
   * @aliases down-tax,download-taxshelter
   */
  public function downloadTaxshelter($year, $folder) {
    \Drupal::service('shareholder_register_taxshelter.drush')
      ->downloadTaxshelter($year, $folder);
  }

  /**
   * This command will create claim for a single share transaction.
   *
   * @param int $transaction_id
   *   Transaction ID.
   *
   * @command taxshelter:claim-for-transaction
   * @aliases claim-for-transaction,taxshelter-claim-for-transaction
   * @option $force Force claim creation (bypass checks)
   */
  public function claimForTransaction($transaction_id, array $options = ['force' => FALSE]) {
    \Drupal::service('shareholder_register_taxshelter.drush')
      ->claimForTransaction($transaction_id, $force);
  }

  /**
   * This command will create claim for a single share transaction.
   *
   * @param int $claim_id
   *   Claim ID.
   *
   * @command taxshelter:document
   * @aliases generate-taxshelter-document
   * @option $force Force claim creation (bypass checks)
   */
  public function generateTaxshelterDocument($claim_id) {
    \Drupal::service('shareholder_register_taxshelter.drush')
      ->generateCertificate($claim_id);
  }

}
