<?php

namespace Drupal\shareholder_register_taxshelter\Entity;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\Core\Entity\EntityPublishedInterface;

/**
 * Provides an interface for defining Taxshelter Belcotax entities.
 *
 * @ingroup shareholder_register_taxshelter
 */
interface TaxshelterBelcotaxInterface extends ContentEntityInterface, EntityChangedInterface, EntityPublishedInterface {

  /**
   * Add get/set methods for your configuration properties here.
   */

  /**
   * Gets the Taxshelter Belcotax name.
   *
   * @return string
   *   Name of the Taxshelter Belcotax.
   */
  public function getName();

  /**
   * Sets the Taxshelter Belcotax name.
   *
   * @param string $name
   *   The Taxshelter Belcotax name.
   *
   * @return \Drupal\shareholder_register_taxshelter\Entity\TaxshelterBelcotaxInterface
   *   The called Taxshelter Belcotax entity.
   */
  public function setName($name);

  /**
   * Gets the Taxshelter Belcotax creation timestamp.
   *
   * @return int
   *   Creation timestamp of the Taxshelter Belcotax.
   */
  public function getCreatedTime();

  /**
   * Sets the Taxshelter Belcotax creation timestamp.
   *
   * @param int $timestamp
   *   The Taxshelter Belcotax creation timestamp.
   *
   * @return \Drupal\shareholder_register_taxshelter\Entity\TaxshelterBelcotaxInterface
   *   The called Taxshelter Belcotax entity.
   */
  public function setCreatedTime($timestamp);

}
