<?php

namespace Drupal\shareholder_register_taxshelter\Entity;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\Core\Entity\EntityPublishedInterface;

/**
 * Provides an interface for defining Taxshelter claim entities.
 *
 * @ingroup shareholder_register_taxshelter
 */
interface TaxshelterClaimInterface extends ContentEntityInterface, EntityChangedInterface, EntityPublishedInterface {

  /**
   * Add get/set methods for your configuration properties here.
   */

  /**
   * Gets the Taxshelter claim creation timestamp.
   *
   * @return int
   *   Creation timestamp of the Taxshelter claim.
   */
  public function getCreatedTime();

  /**
   * Sets the Taxshelter claim creation timestamp.
   *
   * @param int $timestamp
   *   The Taxshelter claim creation timestamp.
   *
   * @return \Drupal\shareholder_register_taxshelter\Entity\TaxshelterClaimInterface
   *   The called Taxshelter claim entity.
   */
  public function setCreatedTime($timestamp);

}
