<?php

namespace Drupal\shareholder_register_taxshelter\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\file\Entity\File;

/**
 * Class ShareholderRegisterTaxshelterConfigForm.
 */
class ShareholderRegisterTaxshelterConfigForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'shareholder_register_taxshelter.settings',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'shareholder_register_taxshelter_config_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('shareholder_register_taxshelter.settings');

    $field_options = [];
    foreach (array_keys(\Drupal::service('entity_type.bundle.info')->getBundleInfo('shareholder')) as $bundle) {
      foreach (\Drupal::service('entity_field.manager')->getFieldDefinitions('shareholder', $bundle) as $fieldname => $field) {
        $field_options[$fieldname] = $field->getLabel();
      }
    }

    $form['rrn_field'] = [
      '#type' => 'select',
      '#title' => $this->t('National Registration Number Field'),
      '#default_value' => $config->get('rrn_field'),
      "#empty_option" => $this->t('- Select -'),
      '#options' => $field_options,
      '#weight' => '5',
    ];
    $form['date_of_birth_field'] = [
      '#type' => 'select',
      '#title' => $this->t('Date of Birth Field'),
      '#default_value' => $config->get('date_of_birth_field'),
      "#empty_option" => $this->t('- Select -'),
      '#options' => $field_options,
      '#weight' => '10',
    ];

    $form['signee_name'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Signee name'),
      '#required' => TRUE,
      '#maxlength' => 64,
      '#size' => 64,
      '#weight' => '15',
      '#default_value' => $config->get('signee_name'),
    ];
    $form['signee_function'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Signee function'),
      '#required' => TRUE,
      '#maxlength' => 64,
      '#size' => 64,
      '#weight' => '20',
      '#default_value' => $config->get('signee_function'),
    ];
    $form['signee_phone'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Signee phone'),
      '#required' => TRUE,
      '#maxlength' => 64,
      '#size' => 64,
      '#weight' => '20',
      '#default_value' => $config->get('signee_phone'),
    ];

    $form['company_type'] = [
      '#type' => 'select',
      '#title' => $this->t('Company status'),
      '#required' => TRUE,
      '#default_value' => $config->get('company_type'),
      '#weight' => '25',
      '#options' => [
        'na' => $this->t('Not applicable'),
        'small' => $this->t('Small company'),
        'micro' => $this->t('Micro company'),
      ]
    ];
    $form['signature_image'] = [
      '#type' => 'managed_file',
      '#title' => t('Signature Image'),
      '#weight' => '30',
      '#upload_validators' => array(
        'file_validate_extensions' => array('gif png jpg jpeg'),
        'file_validate_size' => array(25600000),
      ),
      '#theme' => 'image_widget',
      '#preview_imgage_style' => 'medium',
      '#upload_location' => 'public://taxshelter_signature_image',
      '#progress_message' => 'One moment while we save your file...',
      '#default_value' => $config->get('signature_image'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    parent::validateForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state);

    $signature_image = $form_state->getValue('signature_image');
    if ($signature_image != $this->config('shareholder_register_taxshelter.settings')->get('signature_image')) {
      if (!empty($signature_image[0])) {
        $file = File::load($signature_image[0]);
        $file->setPermanent();
        $file->save();
      }
    }

    $this->config('shareholder_register_taxshelter.settings')
      ->set('rrn_field', $form_state->getValue('rrn_field'))
      ->set('date_of_birth_field', $form_state->getValue('date_of_birth_field'))
      ->set('signee_name', $form_state->getValue('signee_name'))
      ->set('signee_function', $form_state->getValue('signee_function'))
      ->set('signee_phone', $form_state->getValue('signee_phone'))
      ->set('company_type', $form_state->getValue('company_type'))
      ->set('signature_image', $signature_image)
      ->save();
  }

}
