<?php

namespace Drupal\shareholder_register_taxshelter\Form;

use Drupal\Core\Link;
use Drupal\Core\Url;
use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

use Drupal\shareholder_register_taxshelter\Entity\TaxshelterBelcotax;

/**
 * Class TaxshelterBelcotaxForm.
 */
class TaxshelterBelcotaxForm extends FormBase {

  /**
   * Drupal\shareholder_register_taxshelter\ShareholderRegisterTaxshelterServiceInterface definition.
   *
   * @var \Drupal\shareholder_register_taxshelter\ShareholderRegisterTaxshelterServiceInterface
   */
  protected $shareholderRegisterTaxshelterDefault;

  /**
   * Drupal\shareholder_register\ShareholderRegisterServiceInterface definition.
   *
   * @var \Drupal\shareholder_register\ShareholderRegisterServiceInterface
   */
  protected $shareholderRegisterDefault;

  /**
   * Drupal\Core\StreamWrapper\StreamWrapperManagerInterface definition.
   *
   * @var \Drupal\Core\StreamWrapper\StreamWrapperManagerInterface
   */
  protected $streamWrapperManager;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    $instance = parent::create($container);
    $instance->shareholderRegisterTaxshelterDefault = $container->get('shareholder_register_taxshelter.default');
    $instance->shareholderRegisterDefault = $container->get('shareholder_register.default');
    $instance->streamWrapperManager = $container->get('stream_wrapper_manager');
    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'taxshelter_belcotax_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['year'] = [
      '#type' => 'textfield',
      '#disabled' => TRUE,
      '#title' => $this->t("Year"),
      '#default_value' => date("Y", strtotime("-1 year")),
    ];
    $form['final'] = array(
      '#type' => 'checkbox',
      '#title' => $this->t('Final submission'),
    );
    $form['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Submit'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    foreach ($this->shareholderRegisterTaxshelterDefault->checkTaxshelterConfig() as $msg) {
      $form_state->setErrorByName('year', $msg[1]);
    }
    foreach ($this->shareholderRegisterDefault->checkShareholderRegisterConfig() as $msg) {
      $form_state->setErrorByName('year', $msg[1]);
    }
    parent::validateForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    if (count($belcotax_ids = \Drupal::entityQuery('taxshelter_belcotax')
        ->condition('name', $form_state->getValue('year'))
        ->execute())) {
      $belcotax = TaxshelterBelcotax::load(reset($belcotax_ids));
      $fileobj = $belcotax->get('belcotax_xml')->entity;
    }
    else {
      $output = $this->shareholderRegisterTaxshelterDefault->generateBelcotaxXml(
        $form_state->getValue('year'),
        $form_state->getValue('final')
      );

      // Save file.
      $wrappers = $this->streamWrapperManager->getWrappers();
      if (isset($wrappers['private'])) {
        $wrapper = 'private';
      }
      else {
        $wrapper = 'public';
      }
      $destination = $wrapper . '://belcotax.xml';
      $fileobj = file_save_data($output, $destination);
      $fileobj->setTemporary();
      $fileobj->save();
    }

    $file_url = Url::fromUri(file_create_url($fileobj->getFileUri()));
    $link = Link::fromTextAndUrl($this->t('Click here'), $file_url);
    drupal_set_message($this->t('Belcotax document created. @link to download.', array('@link' => $link->toString())));
  }
}
