<?php
namespace Drupal\shareholder_register_taxshelter\Plugin\Action;

use Drupal\views_bulk_operations\Action\ViewsBulkOperationsActionBase;
use Drupal\shareholder_register_taxshelter\Entity\TaxshelterClaim;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Link;
use Drupal\Core\Url;
use Drupal\Core\Session\AccountInterface;

/**
 * Download Taxshelter.
 *
 * @Action(
 *   id = "download_taxshelter_action",
 *   label = @Translation("Download taxshelter documents"),
 *   type = "shareholder"
 * )
 */
class DownloadTaxshelterAction extends ViewsBulkOperationsActionBase {

  /**
   * {@inheritdoc}
   */
  public function execute($entity = NULL) {
    $entity_ids = \Drupal::entityQuery('taxshelter_claim')
      ->condition('shareholder_id', $entity->id())
      ->execute();

    foreach (TaxshelterClaim::loadMultiple($entity_ids) as $claim) {
      if (!$claim->get('statement')->target_id || !$claim->get('statement')->entity->filesize) {
        drupal_set_message("No document for claim #{$claim->id()}", "warning");
        continue;
      }
      $this->context['sandbox']['results'][] = $claim->get('statement')->entity;
    }
    $this->context['sandbox']['result-count'] += 1;
  }

  /**
   * Execute multiple handler.
   */
  public function executeMultiple(array $entities) {
    if (!isset($this->context['sandbox']['results'])) {
      $this->context['sandbox']['results'] = [];
      $this->context['sandbox']['result-count'] = 1;
    }

    foreach ($entities as $entity) {
      $this->execute($entity);
    }

    // Generate the output file if the last row has been processed.
    if (!isset($this->context['sandbox']['total']) || $this->context['sandbox']['result-count'] >= $this->context['sandbox']['total']) {
      $output = $this->generateOutput();
    }
  }

  /**
   * {@inheritdoc}
   */
  protected function generateOutput() {
    $this->streamWrapperManager = \Drupal::service('stream_wrapper_manager');

    $wrappers = $this->streamWrapperManager->getWrappers();
    if (isset($wrappers['private'])) {
      $wrapper = 'private';
    }
    else {
      $wrapper = 'public';
    }

    if (count($this->context['sandbox']['results']) > 1) {
      $destination = $wrapper . '://documents.zip';
      $archive_file = file_save_data('', $destination);
      $archive_file->setTemporary();
      $archive_file->save();

      // FIMXE: dependency injection.
      $zip = \Drupal::service('plugin.manager.archiver')->getInstance(['filepath' => \Drupal::service('file_system')->realpath($archive_file->getFileUri())]);

      $i = 0;
      foreach ($this->context['sandbox']['results'] as $file) {
        // FIXME: filename.
        $fileUri = \Drupal::service('file_system')->realpath($file->getFileUri());
        $zip->getArchive()->addFile($fileUri, "document-{$i}.pdf");
        $i++;
      }

      $file_url = Url::fromUri(file_create_url($archive_file->getFileUri()));
      $link = Link::fromTextAndUrl($this->t('Click here'), $file_url);
      drupal_set_message($this->t('Document archive created. @link to download.', array('@link' => $link->toString())));
    }
    elseif (count($this->context['sandbox']['results']) == 1) {
      $file = reset($this->context['sandbox']['results']);
      $fileUri = \Drupal::service('file_system')->realpath($file->getFileUri());

      // FIXME: filename.
      $destination = $wrapper . '://document.pdf';
      $fileobj = file_save_data(file_get_contents($fileUri), $destination);
      $fileobj->setTemporary();
      $fileobj->save();

      $file_url = Url::fromUri(file_create_url($fileobj->getFileUri()));
      $link = Link::fromTextAndUrl($this->t('Click here'), $file_url);
      drupal_set_message($this->t('Document created. @link to download.', array('@link' => $link->toString())));
    }
    else {
      error_log("NO RESULTS !");
    }
  }

  /**
   * {@inheritdoc}
   */
  public function access($object, AccountInterface $account = NULL, $return_as_object = FALSE) {
    return AccessResult::allowedIfHasPermission($account, 'generate shareholder register taxshelter documents');
  }

}
