<?php

namespace Drupal\shareholder_register_taxshelter;

use Drupal\shareholder_register\Entity\Shareholder;
use Drupal\shareholder_register\Entity\ShareTransaction;

/**
 * Class ShareholderRegisterTaxshelterDrushService.
 */
class ShareholderRegisterTaxshelterDrushService implements ShareholderRegisterTaxshelterDrushServiceInterface {

  /**
   * Drupal\shareholder_register_taxshelter\ShareholderRegisterTaxshelterServiceInterface definition.
   *
   * @var \Drupal\shareholder_register_taxshelter\ShareholderRegisterTaxshelterServiceInterface
   */
  protected $shareholderRegisterTaxshelterDefault;

  /**
   * Constructs a new ShareholderRegisterTaxshelterDrushService object.
   */
  public function __construct(ShareholderRegisterTaxshelterServiceInterface $shareholder_register_taxshelter_default) {
    $this->shareholderRegisterTaxshelterDefault = $shareholder_register_taxshelter_default;
  }

  /**
   * {@inheritdoc}
   */
  public function generateTaxshelter($year, $max_date) {
    $batch = \Drupal::service('shareholder_register_taxshelter.default')
      ->getTaxshelterBatch($year, $max_date);

    batch_set($batch);
    $batch =& batch_get();
    $batch['progressive'] = FALSE;

    // Process the batch.
    drush_backend_batch_process();
  }

  /**
   * {@inheritdoc}
   */
  public function generateSingleTaxshelter($shareholder, $year) {
    $s = Shareholder::load($shareholder);
    $c = [];
    \Drupal::service('shareholder_register_taxshelter.default')
      ->addTaxshelterForShareholder($s, $year, $c);
  }

  /**
   * {@inheritdoc}
   */
  public function downloadTaxshelter($year, $folder) {
    $taxshelter_ids = \Drupal::EntityQuery('file')
      ->condition('type', 'taxshelter_document')
      ->condition('field_year', $year)
      ->execute();
    foreach (File::loadMultiple($taxshelter_ids) as $f) {
      file_copy($f, $folder);
    }
  }

  /**
   * {@inheritdoc}
   */
  public function claimForTransaction($transaction_id, $force = FALSE, $share_ids = FALSE) {
    $transaction = ShareTransaction::load($transaction_id);
    $shares = [];
    if ($share_ids) {
      $shares = explode(',', $share_ids);
    }

    $this->shareholderRegisterTaxshelterDefault->addTaxshelterForShareTransaction(
      $transaction,
      date('Y', strtotime($transaction->getPaymentDate())),
      $force,
      $shares
    );
  }

  /**
   * {@inheritdoc}
   */
  public function generateCertificate($claim_id) {
    if (!$claim_id) {
      return FALSE;
    }
    if ($claim_id == 'all') {
      $claim_ids = \Drupal::entityQuery('taxshelter_claim')->execute();
    }
    elseif (substr($claim_id, 0, 5) === "year-") {
      $claim_ids = \Drupal::entityQuery('taxshelter_claim')
        ->condition('year', substr($claim_id, 5))
        ->execute();
    }
    else {
      $claim_ids = [$claim_id];
    }
    foreach ($claim_ids as $claim_id) {
      \Drupal::service('shareholder_register_taxshelter.default')
        ->generateCertificate($claim_id);
    }
  }
}
