<?php

namespace Drupal\shareholder_register_taxshelter;

use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Access\AccessResult;

/**
 * Access controller for the Taxshelter Belcotax entity.
 *
 * @see \Drupal\shareholder_register_taxshelter\Entity\TaxshelterBelcotax.
 */
class TaxshelterBelcotaxAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    /** @var \Drupal\shareholder_register_taxshelter\Entity\TaxshelterBelcotaxInterface $entity */

    switch ($operation) {

      case 'view':

        if (!$entity->isPublished()) {
          return AccessResult::allowedIfHasPermission($account, 'view unpublished taxshelter belcotax entities');
        }


        return AccessResult::allowedIfHasPermission($account, 'view published taxshelter belcotax entities');

      case 'update':

        return AccessResult::allowedIfHasPermission($account, 'edit taxshelter belcotax entities');

      case 'delete':

        return AccessResult::allowedIfHasPermission($account, 'delete taxshelter belcotax entities');
    }

    // Unknown operation, no opinion.
    return AccessResult::neutral();
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    return AccessResult::allowedIfHasPermission($account, 'add taxshelter belcotax entities');
  }


}
