<?php

namespace Drupal\shareholder_register_taxshelter;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;
use Drupal\Core\Link;

/**
 * Defines a class to build a listing of Taxshelter Belcotax entities.
 *
 * @ingroup shareholder_register_taxshelter
 */
class TaxshelterBelcotaxListBuilder extends EntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['id'] = $this->t('Taxshelter Belcotax ID');
    $header['name'] = $this->t('Name');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /* @var \Drupal\shareholder_register_taxshelter\Entity\TaxshelterBelcotax $entity */
    $row['id'] = $entity->id();
    $row['name'] = Link::createFromRoute(
      $entity->label(),
      'entity.taxshelter_belcotax.edit_form',
      ['taxshelter_belcotax' => $entity->id()]
    );
    return $row + parent::buildRow($entity);
  }

}
