<?php

namespace Drupal\shareholder_register_taxshelter;

use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Access\AccessResult;

/**
 * Access controller for the Taxshelter claim entity.
 *
 * @see \Drupal\shareholder_register_taxshelter\Entity\TaxshelterClaim.
 */
class TaxshelterClaimAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    /** @var \Drupal\shareholder_register_taxshelter\Entity\TaxshelterClaimInterface $entity */

    switch ($operation) {

      case 'view':

        if (!$entity->isPublished()) {
          return AccessResult::allowedIfHasPermission($account, 'view unpublished taxshelter claim entities');
        }


        return AccessResult::allowedIfHasPermission($account, 'view published taxshelter claim entities');

      case 'update':

        return AccessResult::allowedIfHasPermission($account, 'edit taxshelter claim entities');

      case 'delete':

        return AccessResult::allowedIfHasPermission($account, 'delete taxshelter claim entities');
    }

    // Unknown operation, no opinion.
    return AccessResult::neutral();
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    return AccessResult::allowedIfHasPermission($account, 'add taxshelter claim entities');
  }


}
