<?php

namespace Drupal\shareholder_register_taxshelter;

use Symfony\Component\DependencyInjection\ContainerInterface;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;
use Drupal\Core\Entity\EntityStorageInterface;
use Drupal\Core\Entity\EntityTypeInterface;

use Drupal\shareholder_register\ShareholderRegisterFormatterServiceInterface;

/**
 * Defines a class to build a listing of Taxshelter claim entities.
 *
 * @ingroup shareholder_register_taxshelter
 */
class TaxshelterClaimListBuilder extends EntityListBuilder {

  /**
   * Shareholder register Formatter Service.
   *
   * @var \Drupal\shareholder_register\SharholderRegisterFormatterServiceInterface
   */
  protected $shareholderRegisterFormatter;

  /**
   * {@inheritdoc}
   */
  public static function createInstance(ContainerInterface $container, EntityTypeInterface $entity_type) {
    return new static(
      $entity_type,
      $container->get('entity_type.manager')->getStorage($entity_type->id()),
      $container->get('shareholder_register.formatter')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function __construct(EntityTypeInterface $entity_type, EntityStorageInterface $storage, ShareholderRegisterFormatterServiceInterface $formatter) {
    parent::__construct($entity_type, $storage);
    $this->shareholderRegisterFormatter = $formatter;
  }

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['shareholder'] = $this->t('Shareholder');
    $header['year'] = $this->t('Year');
    $header['type'] = $this->t('Type');
    $header['shares'] = $this->t('Shares');
    $header['amount'] = $this->t('Amount');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    $row['shareholder'] = $entity->getShareholder()->label();
    $row['year'] = $entity->getYear();
    $row['type'] = $entity->getType();
    $row['shares'] = $this->shareholderRegisterFormatter->sharesToRanges(
      $entity->getShares());
    $row['amount'] = $entity->getAmount();
    return $row + parent::buildRow($entity);
  }

  /**
   * {@inheritdoc}
   */
  protected function getDefaultOperations(EntityInterface $entity) {
    $operations = parent::getDefaultOperations($entity);

    $operations['view'] = array(
      'title' => $this
        ->t('View'),
      'weight' => 1,
      'url' => $entity
        ->urlInfo('canonical'),
    );

    return $operations;
  }
}
