<?php

namespace Drupal\shareholder_register_vote_weight\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Form to export the Voting Weights for the Shareholder General Meeting.
 */
class ExportGeneralMeetingVoteForm extends FormBase {

  /**
   * GeneralMeetingServiceInterface definition.
   *
   * @var \Drupal\shareholder_register_vote_weight\GeneralMeetingServiceInterface
   */
  protected $srGeneralMeetingDefault;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    $instance = parent::create($container);
    $instance->srGeneralMeetingDefault = $container->get('shareholder_register_vote_weight.default');
    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'export_general_meeting_vote_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['date'] = [
      '#type' => 'date',
      '#title' => $this->t('Date'),
      '#weight' => '0',
      '#required' => TRUE,
      '#default_value' => date('Y-m-d'),
    ];
    $form['use_payment_date'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Use date of payment'),
      '#default_value' => TRUE,
    ];
    $form['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Submit'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $config = [
      'date' => $form_state->getValue('date'),
      'use_payment_date' => $form_state->getValue('use_payment_date'),
    ];
    $batch = $this->srGeneralMeetingDefault->getGeneralMeetingBatch($config);
    batch_set($batch);
  }

}
