<?php

namespace Drupal\shareholder_register_webform\Element;

use CommerceGuys\Addressing\AddressFormat\AddressField;
use CommerceGuys\Addressing\AddressFormat\AddressFormatHelper;
use Drupal\address\FieldHelper;
use Drupal\address\LabelHelper;

use Drupal\Component\Utility\Html;
use Drupal\webform\Element\WebformCompositeBase;
use Drupal\Core\Form\FormStateInterface;

use Drupal\shareholder_register\Entity\ShareType;

/**
 * Provides a 'shareholder address'.
 *
 * @FormElement("shareholder_address")
 *
 * @see \Drupal\webform\Element\WebformCompositeBase
 * @see \Drupal\shareholder_register_webform\Element\Shares
 */
class ShareholderAddress extends WebformCompositeBase {

  /**
   * {@inheritdoc}
   */
  public function getInfo() {
    return parent::getInfo() + ['#theme' => 'shareholder_address'];
  }

  /**
   * {@inheritdoc}
   */
  public static function getCompositeElements(array $element) {
    // Generate an unique ID that can be used by #states.
    $html_id = Html::getUniqueId('shareholder-address');

    $format = "%organization\n%givenName %familyName\n%addressLine1\n%addressLine2\n%postalCode %locality";
    $size_attributes = [
      AddressField::ADMINISTRATIVE_AREA => 30,
      AddressField::LOCALITY => 30,
      AddressField::DEPENDENT_LOCALITY => 30,
      AddressField::POSTAL_CODE => 10,
      AddressField::SORTING_CODE => 10,
      AddressField::GIVEN_NAME => 25,
      AddressField::ADDITIONAL_NAME => 25,
      AddressField::FAMILY_NAME => 25,
    ];

    $labels = LabelHelper::getGenericFieldLabels();
    $grouped_fields = AddressFormatHelper::getGroupedFields($format);

    foreach ($grouped_fields as $line_index => $line_fields) {
      if (count($line_fields) > 1) {
        // Used by the #pre_render callback to group fields inline.
        $element['container' . $line_index] = [
          '#type' => 'container',
          '#attributes' => [
            'class' => ['address-container-inline'],
          ],
        ];
      }

      foreach ($line_fields as $field_index => $field) {
          $property = FieldHelper::getPropertyName($field);
          $class = str_replace('_', '-', $property);
          $elements[$property] = [
            '#type' => 'textfield',
            '#title' => $labels[$field],
            '#default_value' => isset($value[$property]) ? $value[$property] : '',
            // '#required' => in_array($field, $required_fields),
            '#size' => isset($size_attributes[$field]) ? $size_attributes[$field] : 60,
            '#attributes' => [
              'class' => [$class],
            ]
          ];
      }
      if (count($line_fields) > 1) {
        $element[$property]['#group'] = $line_index;
      }
    }

    $elements['country_code'] = [
      '#type' => 'address_country',
      '#title' => t('Country'),
      //'#available_countries' => $element['#available_countries'],
      //'#default_value' => $element['#default_value']['country_code'],
      //'#required' => $element['#required'],
      //'#limit_validation_errors' => [],
      //'#ajax' => [
      //  'callback' => [get_called_class(), 'ajaxRefresh'],
      //  'wrapper' => $wrapper_id,
      //],
      //'#weight' => -100,
    ];

    return $elements;
  }

}
