<?php

namespace Drupal\shareholder_register_webform\Element;

use Drupal\Component\Utility\Html;
use Drupal\webform\Element\WebformCompositeBase;
use Drupal\Core\Form\FormStateInterface;


/**
 * Provides a 'shareholder ID Number'.
 *
 * @FormElement("shareholder_id_number")
 *
 * @see \Drupal\webform\Element\WebformCompositeBase
 * @see \Drupal\shareholder_register_webform\Element\Shares
 */
class ShareholderIDNumber extends WebformCompositeBase {

  /**
   * {@inheritdoc}
   */
  public function getInfo() {
    return parent::getInfo() + [
      '#theme' => 'shareholder_id_card',
      '#element_validate' => [[get_class($this), 'validateIDNumber']],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public static function getCompositeElements(array $element) {
    // Generate an unique ID that can be used by #states.
    $html_id = Html::getUniqueId('shareholder-id-card');

    $elements = [
      'nationality' => [
        '#title' => t('Nationality'),
        '#type' => 'select',
        '#options' => [
          'BE' => t('Belgian'),
        ],
        '#attributes' => ['data-webform-shareholder-nationality' => $html_id . '--nationality'],
      ],
      'id_number' => [
        '#type' => 'textfield',
        '#title' => t('ID Number'),
        '#attributes' => ['data-webform-shareholder-id-number' => $html_id . '--address'],
      ],
    ];
    return $elements;
  }


  /**
   * {@inheritdoc}
   */
  public static function validateIDNumber(&$element, FormStateInterface $form_state, &$complete_form) {
    if ($form_state->getValue([$element['#name'], 'nationality']) == 'BE') {
      $id_number = $form_state->getValue([$element['#name'], 'id_number']);
      $id = preg_replace( '/[^0-9]/', '', $id_number);

      if (strlen($id) != 11) {
        $form_state->setError(
          $element,
          t('Please enter your National number (rijksregisternummer). It should contain 11 digits.')
        );
      }

      $check = substr($id, 9);
      if ((97 - (substr($id, 0, 9) % 97)) != $check &&
        ((97 - (substr($id, 0, 9) + 2000000000) % 97)) != $check) {
        $form_state->setError(
          $element,
          t('The National number (rijksregisternummer) is incorrect!')
        );
      }
    }
  }

}
