<?php

namespace Drupal\shareholder_register_webform\Element;

use Drupal\Component\Utility\Html;
use Drupal\webform\Element\WebformCompositeBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a 'shareholder_number'.
 *
 * @FormElement("shareholder_number")
 *
 * @see \Drupal\webform\Element\WebformCompositeBase
 * @see \Drupal\shareholder_register_webform\Element\ShareholderNumber
 */
class ShareholderNumber extends WebformCompositeBase {

  /**
   * {@inheritdoc}
   */
  public function getInfo() {
    return parent::getInfo() + [
      '#theme' => 'shareholder_number',
      '#element_validate' => [[get_class($this), 'validateShareholderNumber']],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public static function getCompositeElements(array $element) {
    // Generate an unique ID that can be used by #states.
    $html_id = Html::getUniqueId('shareholder_number');

    $elements = [
      'number' => [
        '#type' => 'textfield',
        '#title' => t('Shareholder Number'),
        '#attributes' => ['data-webform-shareholder-number-id' => $html_id . '--number'],
      ],
      'mail' => [
        '#type' => 'textfield',
        '#title' => t('Registered Mail'),
        '#attributes' => ['data-webform-shareholder-number-id' => $html_id . '--mail'],
      ],
      'shareholder_id' => [
        '#type' => 'value'
      ]
    ];
    return $elements;
  }

  /**
   * {@inheritdoc}
   */
  public static function validateShareholderNumber(&$element, FormStateInterface $form_state, &$complete_form) {
    $parents = $element['#parents'];
    $shareholder_id_key = array_merge($parents, ['shareholder_id']);
    $values = $form_state->getValue($parents);

    $number = $values['number'];
    $mail = $values['mail'];

    if (strlen($number)) {
      $query = \Drupal::entityQuery('shareholder')
        ->condition('number', $number)
        ->condition('mail', $mail);
      $values = $query->execute();
      if (count($values) != 1) {
        $form_state->setError(
          $element, t('Your shareholder number and registered mail address could not be found in the register!')
        );
        $form_state->setValue($shareholder_id_key, NULL);
      }
      else {
        $form_state->setValue($shareholder_id_key, reset($values));
      }
    }
    else {
      $form_state->setValue($shareholder_id_key, NULL);
    }
  }
}
