<?php

namespace Drupal\shareholder_register_webform\Plugin\WebformElement;

use Drupal\webform\Plugin\WebformElement\WebformCompositeBase;
use Drupal\webform\WebformSubmissionInterface;

/**
 * Provides a 'shareholder_address' element.
 *
 * @WebformElement(
 *   id = "shareholder_address",
 *   label = @Translation("Shareholder Address"),
 *   description = @Translation("Provides a Shareholder Address composite."),
 *   category = @Translation("Shareholder Register"),
 *   multiline = TRUE,
 *   composite = TRUE,
 *   states_wrapper = TRUE,
 * )
 *
 * @see \Drupal\webform\Plugin\WebformElement\WebformCompositeBase
 * @see \Drupal\webform\Plugin\WebformElementBase
 * @see \Drupal\webform\Plugin\WebformElementInterface
 * @see \Drupal\webform\Annotation\WebformElement
 */
class ShareholderAddress extends WebformCompositeBase {

  /**
   * {@inheritdoc}
   */
  protected function formatHtmlItemValue(array $element, WebformSubmissionInterface $webform_submission, array $options = []) {
    return $this->formatTextItemValue($element, $webform_submission, $options);
  }

  /**
   * {@inheritdoc}
   */
  protected function formatTextItemValue(array $element, WebformSubmissionInterface $webform_submission, array $options = []) {
    $value = $this->getValue($element, $webform_submission, $options);

    $lines = [];
    foreach (['given_name', 'family_name', 'address_line1', 'country_code'] as $k) {
      if (!empty($value[$k])) {
        $lines[$k] = $value[$k];
      }
    }
    //$lines[] = ($value['number'] ? $value['number'] : '') .
    //  ($value['mail'] ? ' ' . $value['mail'] : '');
    return $lines;
  }

}
