<?php

namespace Drupal\shareholder_register_webform\Plugin\WebformElement;

use Drupal\webform\Plugin\WebformElement\WebformCompositeBase;
use Drupal\webform\WebformSubmissionInterface;

/**
 * Provides a 'shareholder_id_number' element.
 *
 * @WebformElement(
 *   id = "shareholder_id_number",
 *   label = @Translation("Shareholder ID Number"),
 *   description = @Translation("Provides a Shareholder ID Number composite."),
 *   category = @Translation("Shareholder Register"),
 *   multiline = TRUE,
 *   composite = TRUE,
 *   states_wrapper = TRUE,
 * )
 *
 * @see \Drupal\webform\Plugin\WebformElement\WebformCompositeBase
 * @see \Drupal\webform\Plugin\WebformElementBase
 * @see \Drupal\webform\Plugin\WebformElementInterface
 * @see \Drupal\webform\Annotation\WebformElement
 */
class ShareholderIDNumber extends WebformCompositeBase {

  /**
   * {@inheritdoc}
   */
  protected function formatHtmlItemValue(array $element, WebformSubmissionInterface $webform_submission, array $options = []) {
    return $this->formatTextItemValue($element, $webform_submission, $options);
  }

  /**
   * {@inheritdoc}
   */
  protected function formatTextItemValue(array $element, WebformSubmissionInterface $webform_submission, array $options = []) {
    $value = $this->getValue($element, $webform_submission, $options);

    $lines = [];
    //$lines[] = ($value['number'] ? $value['number'] : '') .
    //  ($value['mail'] ? ' ' . $value['mail'] : '');
    return $lines;
  }

}
