<?php

namespace Drupal\shareholder_register_webform\Plugin\WebformElement;

use Drupal\webform\Plugin\WebformElement\WebformCompositeBase;
use Drupal\webform\WebformSubmissionInterface;

/**
 * Provides a 'shareholder_number' element.
 *
 * @WebformElement(
 *   id = "shareholder_number",
 *   label = @Translation("Shareholder Number and Mail validation"),
 *   description = @Translation("Provides a Shareholder Number and Mail composite."),
 *   category = @Translation("Shareholder Register"),
 *   multiline = TRUE,
 *   composite = TRUE,
 *   states_wrapper = TRUE,
 * )
 *
 * @see \Drupal\webform\Plugin\WebformElement\WebformCompositeBase
 * @see \Drupal\webform\Plugin\WebformElementBase
 * @see \Drupal\webform\Plugin\WebformElementInterface
 * @see \Drupal\webform\Annotation\WebformElement
 */
class ShareholderNumber extends WebformCompositeBase {

  /**
   * {@inheritdoc}
   */
  protected function formatHtmlItemValue(array $element, WebformSubmissionInterface $webform_submission, array $options = []) {
    return $this->formatTextItemValue($element, $webform_submission, $options);
  }

  /**
   * {@inheritdoc}
   */
  protected function formatTextItemValue(array $element, WebformSubmissionInterface $webform_submission, array $options = []) {
    $value = $this->getValue($element, $webform_submission, $options);

    $lines = [];
    $lines[] = (isset($value['number']) ? $value['number'] : '') .
             (isset($value['mail']) ? ' ' . $value['mail'] : '');
    return $lines;
  }

}
