<?php
namespace Drupal\shareholder_register_webform\Plugin\WebformElement;

use Drupal\Core\Form\FormStateInterface;

use Drupal\webform\Plugin\WebformElement\WebformCompositeBase;
use Drupal\webform\WebformSubmissionInterface;

use Drupal\shareholder_register\Entity\ShareIssue;

/**
 * Provides a 'shares' element.
 *
 * @WebformElement(
 *   id = "shareholder_shares",
 *   label = @Translation("Shares selection element"),
 *   description = @Translation("Provides a Shares selection composite."),
 *   category = @Translation("Shareholder Register"),
 *   multiline = TRUE,
 *   composite = TRUE,
 *   states_wrapper = TRUE,
 * )
 *
 * @see \Drupal\webform\Plugin\WebformElement\WebformCompositeBase
 * @see \Drupal\webform\Plugin\WebformElementBase
 * @see \Drupal\webform\Plugin\WebformElementInterface
 * @see \Drupal\webform\Annotation\WebformElement
 */
class ShareholderShares extends WebformCompositeBase {

  /**
   * {@inheritdoc}
   */
  protected function formatHtmlItemValue(array $element, WebformSubmissionInterface $webform_submission, array $options = []) {
    return $this->formatTextItemValue($element, $webform_submission, $options);
  }

  /**
   * {@inheritdoc}
   */
  protected function formatTextItemValue(array $element, WebformSubmissionInterface $webform_submission, array $options = []) {
    $value = $this->getValue($element, $webform_submission, $options);

    if ($value['share_quantity'] && $value['share_issue']) {
      $share_issue = ShareIssue::load($value['share_issue']);
      return ["{$value['share_quantity']} {$share_issue->getName()}"];
    }
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public function getDefaultProperties() {
    return [
      'shareholder_number_key' => '',
    ] + parent::getDefaultProperties();
  }

  /**
   * {@inheritdoc}
   */
  public function form(array $form, FormStateInterface $form_state) {
    $form = parent::form($form, $form_state);
    $form['element']['shareholder_number_key'] = [
      '#type' => 'textfield',
      '#title' => 'Shareholder Number Key',
      '#description' => 'The key for the shareholder number element (used for max qty validation).',
    ];
    return $form;
  }

}
